#include <stdio.h>
#include <stdlib.h>

long long int getFreeMem(void) {
    
    FILE *meminfo = fopen("/proc/meminfo", "r");
    
    unsigned long long int ramB = 0;
    unsigned long long int ramKB = 0;
    char buff[1024];
    
    if(meminfo == NULL){
        return -1;
    }
    
    while(fgets(buff, sizeof(buff), meminfo)){
        if(sscanf(buff, "MemAvailable: %llu kB", &ramKB) == 1){
            ramB = ramKB * 1024;
        }
    }
    
    if(fclose(meminfo)){
        return -1;
    }
    
    return (long long int)ramB;
}



int main() {
    
    int val = 0;
    unsigned long long int err = 0; 
    long long int freeMem = getFreeMem();
    
    if(freeMem == -1)
        return -1;
    
    unsigned long long int size = freeMem / sizeof(unsigned long long int), i = 0;
    
    unsigned long long int *block = malloc(size * sizeof(unsigned long long int));
    
    for(i = 0, val = 0; i < size; i++, val++){
        if(val > 100)
            val = 0;
        block[i] = val;
    }
    
    while(err < 5){
        for(i = 0, val = 0; i < size; i++, val++){
            if(val > 100)
                val = 0;
            
            if(block[i] != val){
                err++;
                printf("ERROR ON %llu -- BLOCK IS: %llu, SHOULD BE: %d -- CORRECTING\n",i, block[i],val);
                block[i] = val;
            }
            
            if(0 == i % 50000000)
                printf("BYTE N: %llu VAL-- %llu\n",i,block[i]);
        }
    }
    
    scanf("%llu",&i);
    free(block);
    
    return 0;
}
